/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.ConfigurationParameters;

class LauncherConfigurationParameters
implements ConfigurationParameters {
    private static final Logger logger = LoggerFactory.getLogger(LauncherConfigurationParameters.class);
    private final List<ParameterProvider> providers;

    static Builder builder() {
        return new Builder();
    }

    private LauncherConfigurationParameters(List<ParameterProvider> providers) {
        this.providers = providers;
    }

    @Override
    public Optional<String> get(String key) {
        return Optional.ofNullable(this.getProperty(key));
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        return this.get(key).map(Boolean::parseBoolean);
    }

    @Override
    public int size() {
        return this.providers.stream().mapToInt(ParameterProvider::size).sum();
    }

    private String getProperty(String key) {
        Preconditions.notBlank(key, "key must not be null or blank");
        return this.providers.stream().map(parameterProvider -> parameterProvider.getValue(key)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String toString() {
        return new ToStringBuilder(this).append("lookups", this.providers).toString();
    }

    private static Properties loadClasspathResource(String configFileName) {
        Properties props;
        block9: {
            props = new Properties();
            try {
                ClassLoader classLoader = ClassLoaderUtils.getDefaultClassLoader();
                LinkedHashSet<URL> resources = new LinkedHashSet<URL>(Collections.list(classLoader.getResources(configFileName)));
                if (resources.isEmpty()) break block9;
                if (resources.size() > 1) {
                    logger.warn(() -> String.format("Discovered %d '%s' configuration files in the classpath; only the first will be used.", resources.size(), configFileName));
                }
                URL configFileUrl = (URL)resources.iterator().next();
                logger.config(() -> String.format("Loading JUnit Platform configuration parameters from classpath resource [%s].", configFileUrl));
                URLConnection urlConnection = configFileUrl.openConnection();
                urlConnection.setUseCaches(false);
                try (InputStream inputStream = urlConnection.getInputStream();){
                    props.load(inputStream);
                }
            }
            catch (Exception ex) {
                logger.warn(ex, () -> String.format("Failed to load JUnit Platform configuration parameters from classpath resource [%s].", configFileName));
            }
        }
        return props;
    }

    static final class Builder {
        private final Map<String, String> explicitParameters = new HashMap<String, String>();
        private boolean implicitProvidersEnabled = true;
        private String configFileName = "junit-platform.properties";
        private ConfigurationParameters parentConfigurationParameters;

        private Builder() {
        }

        Builder explicitParameters(Map<String, String> parameters) {
            Preconditions.notNull(parameters, "configuration parameters must not be null");
            this.explicitParameters.putAll(parameters);
            return this;
        }

        Builder enableImplicitProviders(boolean enabled) {
            this.implicitProvidersEnabled = enabled;
            return this;
        }

        Builder configFileName(String configFileName) {
            Preconditions.notBlank(configFileName, "configFileName must not be null or blank");
            this.configFileName = configFileName;
            return this;
        }

        Builder parentConfigurationParameters(ConfigurationParameters parameters) {
            Preconditions.notNull(parameters, "parent configuration parameters must not be null");
            this.parentConfigurationParameters = parameters;
            return this;
        }

        LauncherConfigurationParameters build() {
            ArrayList<ParameterProvider> parameterProviders = new ArrayList<ParameterProvider>();
            if (!this.explicitParameters.isEmpty()) {
                parameterProviders.add(ParameterProvider.explicit(this.explicitParameters));
            }
            if (this.parentConfigurationParameters != null) {
                parameterProviders.add(ParameterProvider.inherited(this.parentConfigurationParameters));
            }
            if (this.implicitProvidersEnabled) {
                parameterProviders.add(ParameterProvider.systemProperties());
                parameterProviders.add(ParameterProvider.propertiesFile(this.configFileName));
            }
            return new LauncherConfigurationParameters(parameterProviders);
        }
    }

    private static interface ParameterProvider {
        public String getValue(String var1);

        default public int size() {
            return 0;
        }

        public static ParameterProvider explicit(final Map<String, String> configParams) {
            return new ParameterProvider(){

                @Override
                public String getValue(String key) {
                    return (String)configParams.get(key);
                }

                @Override
                public int size() {
                    return configParams.size();
                }

                public String toString() {
                    ToStringBuilder builder = new ToStringBuilder("explicit");
                    configParams.forEach(builder::append);
                    return builder.toString();
                }
            };
        }

        public static ParameterProvider systemProperties() {
            return new ParameterProvider(){

                @Override
                public String getValue(String key) {
                    try {
                        return System.getProperty(key);
                    }
                    catch (Exception ignore) {
                        return null;
                    }
                }

                public String toString() {
                    return "systemProperties [...]";
                }
            };
        }

        public static ParameterProvider propertiesFile(String configFileName) {
            Preconditions.notBlank(configFileName, "configFileName must not be null or blank");
            final Properties properties = LauncherConfigurationParameters.loadClasspathResource(configFileName.trim());
            return new ParameterProvider(){

                @Override
                public String getValue(String key) {
                    return properties.getProperty(key);
                }

                public String toString() {
                    ToStringBuilder builder = new ToStringBuilder("propertiesFile");
                    properties.stringPropertyNames().forEach(key -> builder.append((String)key, this.getValue((String)key)));
                    return builder.toString();
                }
            };
        }

        public static ParameterProvider inherited(final ConfigurationParameters configParams) {
            return new ParameterProvider(){

                @Override
                public String getValue(String key) {
                    return configParams.get(key).orElse(null);
                }

                @Override
                public int size() {
                    return configParams.size();
                }

                public String toString() {
                    ToStringBuilder builder = new ToStringBuilder("inherited");
                    builder.append("parent", configParams);
                    return builder.toString();
                }
            };
        }
    }
}

