/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.ps;

import com.sun.javafx.geom.Rectangle;
import com.sun.prism.ps.Shader;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.PhongLighting;
import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.ps.PPSTwoSamplerPeer;
import com.sun.scenario.effect.light.PointLight;
import com.sun.scenario.effect.light.SpotLight;
import java.nio.FloatBuffer;
import java.util.HashMap;

public class PPSPhongLighting_SPOTPeer
extends PPSTwoSamplerPeer {
    private FloatBuffer kvals;

    public PPSPhongLighting_SPOTPeer(FilterContext filterContext, Renderer renderer, String string) {
        super(filterContext, renderer, string);
    }

    @Override
    protected final PhongLighting getEffect() {
        return (PhongLighting)super.getEffect();
    }

    private float getSurfaceScale() {
        return this.getEffect().getSurfaceScale();
    }

    private float getDiffuseConstant() {
        return this.getEffect().getDiffuseConstant();
    }

    private float getSpecularConstant() {
        return this.getEffect().getSpecularConstant();
    }

    private float getSpecularExponent() {
        return this.getEffect().getSpecularExponent();
    }

    private float[] getNormalizedLightPosition() {
        return this.getEffect().getLight().getNormalizedLightPosition();
    }

    private float[] getLightPosition() {
        PointLight pointLight = (PointLight)this.getEffect().getLight();
        return new float[]{pointLight.getX(), pointLight.getY(), pointLight.getZ()};
    }

    private float[] getLightColor() {
        return this.getEffect().getLight().getColor().getPremultipliedRGBComponents();
    }

    private float getLightSpecularExponent() {
        return ((SpotLight)this.getEffect().getLight()).getSpecularExponent();
    }

    private float[] getNormalizedLightDirection() {
        return ((SpotLight)this.getEffect().getLight()).getNormalizedLightDirection();
    }

    private FloatBuffer getKvals() {
        Rectangle rectangle = this.getInputNativeBounds(0);
        float f = 1.0f / (float)rectangle.width;
        float f2 = 1.0f / (float)rectangle.height;
        float[] fArray = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
        float[] fArray2 = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
        if (this.kvals == null) {
            this.kvals = BufferUtil.newFloatBuffer(32);
        }
        this.kvals.clear();
        int n = 0;
        float f3 = -this.getSurfaceScale() * 0.25f;
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (j != 0 || k != 0) {
                    this.kvals.put((float)k * f);
                    this.kvals.put((float)j * f2);
                    this.kvals.put(fArray[n] * f3);
                    this.kvals.put(fArray2[n] * f3);
                }
                ++n;
            }
        }
        this.kvals.rewind();
        return this.kvals;
    }

    private int getKvalsArrayLength() {
        return 8;
    }

    @Override
    protected boolean isSamplerLinear(int n) {
        switch (n) {
            default: 
        }
        return false;
    }

    @Override
    protected Shader createShader() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("bumpImg", 0);
        hashMap.put("origImg", 1);
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        hashMap2.put("lightPosition", 13);
        hashMap2.put("lightSpecularExponent", 15);
        hashMap2.put("specularExponent", 2);
        hashMap2.put("kvals", 4);
        hashMap2.put("diffuseConstant", 0);
        hashMap2.put("lightColor", 3);
        hashMap2.put("normalizedLightDirection", 14);
        hashMap2.put("specularConstant", 1);
        hashMap2.put("surfaceScale", 12);
        return this.getRenderer().createShader(this.getShaderName(), hashMap, hashMap2, true);
    }

    @Override
    protected void updateShader(Shader shader) {
        float[] fArray = this.getLightPosition();
        shader.setConstant("lightPosition", fArray[0], fArray[1], fArray[2]);
        shader.setConstant("lightSpecularExponent", this.getLightSpecularExponent());
        shader.setConstant("specularExponent", this.getSpecularExponent());
        shader.setConstants("kvals", this.getKvals(), 0, this.getKvalsArrayLength());
        shader.setConstant("diffuseConstant", this.getDiffuseConstant());
        float[] fArray2 = this.getLightColor();
        shader.setConstant("lightColor", fArray2[0], fArray2[1], fArray2[2]);
        float[] fArray3 = this.getNormalizedLightDirection();
        shader.setConstant("normalizedLightDirection", fArray3[0], fArray3[1], fArray3[2]);
        shader.setConstant("specularConstant", this.getSpecularConstant());
        shader.setConstant("surfaceScale", this.getSurfaceScale());
    }
}

