/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.AccessHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Effect {
    public static final Effect DefaultInput = null;
    private final List<Effect> inputs;
    private final List<Effect> unmodifiableInputs;
    private final int maxInputs;

    protected Effect() {
        this.inputs = Collections.emptyList();
        this.unmodifiableInputs = this.inputs;
        this.maxInputs = 0;
    }

    protected Effect(Effect effect) {
        this.inputs = new ArrayList<Effect>(1);
        this.unmodifiableInputs = Collections.unmodifiableList(this.inputs);
        this.maxInputs = 1;
        this.setInput(0, effect);
    }

    protected Effect(Effect effect, Effect effect2) {
        this.inputs = new ArrayList<Effect>(2);
        this.unmodifiableInputs = Collections.unmodifiableList(this.inputs);
        this.maxInputs = 2;
        this.setInput(0, effect);
        this.setInput(1, effect2);
    }

    Object getState() {
        return null;
    }

    public int getNumInputs() {
        return this.inputs.size();
    }

    public final List<Effect> getInputs() {
        return this.unmodifiableInputs;
    }

    protected void setInput(int n, Effect effect) {
        if (n < 0 || n >= this.maxInputs) {
            throw new IllegalArgumentException("Index must be within allowable range");
        }
        if (n < this.inputs.size()) {
            this.inputs.set(n, effect);
        } else {
            this.inputs.add(effect);
        }
    }

    public static BaseBounds combineBounds(BaseBounds ... baseBoundsArray) {
        BaseBounds baseBounds = null;
        if (baseBoundsArray.length == 1) {
            baseBounds = baseBoundsArray[0];
        } else {
            for (int j = 0; j < baseBoundsArray.length; ++j) {
                BaseBounds baseBounds2 = baseBoundsArray[j];
                if (baseBounds2 == null || baseBounds2.isEmpty()) continue;
                if (baseBounds == null) {
                    baseBounds = new RectBounds();
                    baseBounds = baseBounds.deriveWithNewBounds(baseBounds2);
                    continue;
                }
                baseBounds = baseBounds.deriveWithUnion(baseBounds2);
            }
        }
        if (baseBounds == null) {
            baseBounds = new RectBounds();
        }
        return baseBounds;
    }

    public static Rectangle combineBounds(Rectangle ... rectangleArray) {
        Rectangle rectangle = null;
        if (rectangleArray.length == 1) {
            rectangle = rectangleArray[0];
        } else {
            for (int j = 0; j < rectangleArray.length; ++j) {
                Rectangle rectangle2 = rectangleArray[j];
                if (rectangle2 == null || rectangle2.isEmpty()) continue;
                if (rectangle == null) {
                    rectangle = new Rectangle(rectangle2);
                    continue;
                }
                rectangle.add(rectangle2);
            }
        }
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        return rectangle;
    }

    public Rectangle getResultBounds(BaseTransform baseTransform, Rectangle rectangle, ImageData ... imageDataArray) {
        int n = imageDataArray.length;
        Rectangle[] rectangleArray = new Rectangle[n];
        for (int j = 0; j < n; ++j) {
            rectangleArray[j] = imageDataArray[j].getTransformedBounds(rectangle);
        }
        Rectangle rectangle2 = Effect.combineBounds(rectangleArray);
        return rectangle2;
    }

    public abstract ImageData filter(FilterContext var1, BaseTransform var2, Rectangle var3, Object var4, Effect var5);

    public static BaseBounds transformBounds(BaseTransform baseTransform, BaseBounds baseBounds) {
        if (baseTransform == null || baseTransform.isIdentity()) {
            return baseBounds;
        }
        BaseBounds baseBounds2 = new RectBounds();
        baseBounds2 = baseTransform.transform(baseBounds, baseBounds2);
        return baseBounds2;
    }

    protected ImageData ensureTransform(FilterContext filterContext, ImageData imageData, BaseTransform baseTransform, Rectangle rectangle) {
        if (baseTransform == null || baseTransform.isIdentity()) {
            return imageData;
        }
        if (!imageData.validate(filterContext)) {
            imageData.unref();
            return new ImageData(filterContext, null, new Rectangle());
        }
        return imageData.transform(baseTransform);
    }

    public DirtyRegionContainer getDirtyRegions(Effect effect, DirtyRegionPool dirtyRegionPool) {
        DirtyRegionContainer dirtyRegionContainer = null;
        for (int j = 0; j < this.inputs.size(); ++j) {
            DirtyRegionContainer dirtyRegionContainer2 = this.getDefaultedInput(j, effect).getDirtyRegions(effect, dirtyRegionPool);
            if (dirtyRegionContainer == null) {
                dirtyRegionContainer = dirtyRegionContainer2;
                continue;
            }
            dirtyRegionContainer.merge(dirtyRegionContainer2);
            dirtyRegionPool.checkIn(dirtyRegionContainer2);
        }
        if (dirtyRegionContainer == null) {
            dirtyRegionContainer = dirtyRegionPool.checkOut();
        }
        return dirtyRegionContainer;
    }

    Effect getDefaultedInput(int n, Effect effect) {
        return Effect.getDefaultedInput(this.inputs.get(n), effect);
    }

    static Effect getDefaultedInput(Effect effect, Effect effect2) {
        return effect == null ? effect2 : effect;
    }

    public abstract BaseBounds getBounds(BaseTransform var1, Effect var2);

    public Point2D transform(Point2D point2D, Effect effect) {
        return point2D;
    }

    public Point2D untransform(Point2D point2D, Effect effect) {
        return point2D;
    }

    public static Filterable createCompatibleImage(FilterContext filterContext, int n, int n2) {
        return Renderer.getRenderer(filterContext).createCompatibleImage(n, n2);
    }

    public static Filterable getCompatibleImage(FilterContext filterContext, int n, int n2) {
        return Renderer.getRenderer(filterContext).getCompatibleImage(n, n2);
    }

    public static void releaseCompatibleImage(FilterContext filterContext, Filterable filterable) {
        Renderer.getRenderer(filterContext).releaseCompatibleImage(filterable);
    }

    public abstract boolean reducesOpaquePixels();

    public abstract AccelType getAccelType(FilterContext var1);

    static {
        AccessHelper.setStateAccessor(effect -> effect.getState());
    }

    public static enum AccelType {
        INTRINSIC("Intrinsic"),
        NONE("CPU/Java"),
        SIMD("CPU/SIMD"),
        FIXED("CPU/Fixed"),
        OPENGL("OpenGL"),
        DIRECT3D("Direct3D");

        private String text;

        private AccelType(String string2) {
            this.text = string2;
        }

        public String toString() {
            return this.text;
        }
    }
}

