/*
 * Decompiled with CFR 0.152.
 */
package algebrafx;

import algebrafx.Equation;
import algebrafx.Expression;
import javafx.animation.FadeTransition;
import javafx.animation.FillTransition;
import javafx.animation.RotateTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.effect.DropShadow;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import javafx.util.Duration;

public class Solver
extends Application {
    @Override
    public void start(Stage mainStage) throws Exception {
        mainStage.setTitle("Equation Solver");
        GridPane menu = new GridPane();
        menu.setAlignment(Pos.CENTER);
        GridPane root = new GridPane();
        root.setAlignment(Pos.CENTER);
        GridPane settings = new GridPane();
        settings.setAlignment(Pos.CENTER);
        Label title = new Label("Equation Solver");
        menu.addRow(0, title);
        title.setWrapText(true);
        title.setAlignment(Pos.CENTER);
        title.setFont(new Font("Arial", 50.0));
        Button playBtn = new Button(" Play ");
        menu.addRow(2, playBtn);
        playBtn.setAlignment(Pos.CENTER);
        playBtn.setFont(new Font(20.0));
        playBtn.setTranslateX(150.0);
        playBtn.setTranslateY(25.0);
        Button settingsBtn = new Button("Settings");
        menu.addRow(4, settingsBtn);
        settingsBtn.setFont(new Font(20.0));
        settingsBtn.setTranslateX(137.0);
        settingsBtn.setTranslateY(50.0);
        Button exitBtn = new Button(" Exit ");
        menu.addRow(6, exitBtn);
        exitBtn.setFont(new Font(20.0));
        exitBtn.setTranslateX(150.0);
        exitBtn.setTranslateY(75.0);
        Label darkMode = new Label("Enable Dark Mode");
        CheckBox darkSelect = new CheckBox();
        settings.addRow(0, darkMode, darkSelect);
        darkSelect.setTranslateX(25.0);
        Label fullScreen = new Label("Enable Full Screen");
        CheckBox fullSelect = new CheckBox();
        settings.addRow(1, fullScreen, fullSelect);
        fullScreen.setTranslateY(25.0);
        fullSelect.setTranslateX(25.0);
        fullSelect.setTranslateY(25.0);
        TextField input = new TextField();
        Label inputLabel = new Label("Welcome! Please enter an equation or expression to solve.");
        root.add(inputLabel, 3, 0);
        root.add(input, 3, 2);
        input.setOpacity(0.0);
        Arc upperBubble = new Arc(-5.0, 10.0, inputLabel.getText().length() * 3, 20.0, 0.0, 180.0);
        upperBubble.setType(ArcType.OPEN);
        upperBubble.setSmooth(true);
        upperBubble.setFill(Color.WHITE);
        upperBubble.setStroke(Color.BLACK);
        upperBubble.setStrokeWidth(3.0);
        Arc lowerBubble = new Arc(-5.0, 10.0, inputLabel.getText().length() * 3, 20.0, 180.0, 185.0);
        Arc divider = new Arc(-5.0, 10.0, inputLabel.getText().length() * 3, 20.0, 190.0, 30.0);
        lowerBubble.setType(ArcType.OPEN);
        lowerBubble.setSmooth(true);
        lowerBubble.setFill(Color.WHITE);
        lowerBubble.setStroke(Color.BLACK);
        lowerBubble.setStrokeWidth(3.0);
        divider.setFill(Color.TRANSPARENT);
        divider.setStroke(Color.WHITE);
        divider.setStrokeWidth(3.0);
        Polygon direction = new Polygon(0.0, 0.0, 40.0, 0.0, 0.0, 40.0);
        Group speech = new Group(direction, upperBubble, lowerBubble, divider, inputLabel);
        root.add(speech, 3, 0);
        inputLabel.setTranslateX(-150.0);
        direction.setTranslateX(-lowerBubble.getRadiusX() - 13.0);
        direction.setTranslateY(lowerBubble.getRadiusY() - 5.0);
        direction.setRotate(20.0);
        direction.setFill(Color.TRANSPARENT);
        direction.setStroke(Color.BLACK);
        direction.setStrokeWidth(3.0);
        speech.setOpacity(0.0);
        Button solveBtn = new Button("Solve!");
        root.add(solveBtn, 4, 2);
        solveBtn.setOpacity(0.0);
        TextField result = new TextField();
        result.setEditable(false);
        Label resultLabel = new Label("Result: ");
        root.add(resultLabel, 3, 3);
        root.add(result, 3, 5);
        resultLabel.setOpacity(0.0);
        result.setOpacity(0.0);
        Button rootBack = new Button("Back");
        root.add(rootBack, 3, 6);
        rootBack.setTranslateY(25.0);
        Button settingsBack = new Button("Back");
        settings.add(settingsBack, 1, 2);
        settingsBack.setTranslateY(50.0);
        Circle loadingCircle = new Circle(5.0);
        Circle loadingCircle2 = new Circle(5.0);
        Circle loadingCircle3 = new Circle(5.0);
        Circle[] loadingArr = new Circle[]{loadingCircle, loadingCircle2, loadingCircle3};
        Group loading = new Group(loadingCircle, loadingCircle2, loadingCircle3);
        root.add(loading, 3, 5);
        loadingCircle2.setTranslateX(5.0 * loadingCircle.getRadius());
        loadingCircle3.setTranslateX(10.0 * loadingCircle.getRadius());
        loading.setOpacity(0.0);
        Stop[] stops = new Stop[]{new Stop(0.0, Color.RED), new Stop(1.0, Color.WHITE)};
        LinearGradient grad = new LinearGradient(0.0, 5.0, 5.0, 0.0, false, CycleMethod.REPEAT, stops);
        Polygon cone = new Polygon(-25.0, 25.0, 25.0, 25.0, 0.0, 75.0);
        Circle lowerCream = new Circle(25.0, Color.AQUA);
        Circle upperCream = new Circle(25.0, Color.PINK);
        Circle cherry = new Circle(10.0, Color.rgb(204, 37, 44));
        Rectangle straw = new Rectangle(30.0, 5.0, grad);
        Rectangle leftArm = new Rectangle(60.0, 10.0, Color.rgb(205, 162, 111));
        Rectangle rightArm = new Rectangle(60.0, 10.0, Color.rgb(205, 162, 111));
        Group arms = new Group(leftArm, rightArm);
        Circle leftEye = new Circle(0.0, 10.0, 5.0);
        Circle rightEye = new Circle(0.0, 10.0, 5.0);
        Group eyes = new Group(leftEye, rightEye);
        Polygon triangleLeftEye = new Polygon(-5.0, 10.0, -15.0, 10.0, -10.0, 15.0);
        Polygon triangleRightEye = new Polygon(15.0, 10.0, 5.0, 10.0, 10.0, 15.0);
        Group triangleEyes = new Group(triangleLeftEye, triangleRightEye);
        Arc happyLeftEye = new Arc(-10.0, 10.0, 5.0, 5.0, 0.0, 180.0);
        Arc happyRightEye = new Arc(10.0, 10.0, 5.0, 5.0, 0.0, 180.0);
        Group happyEyes = new Group(happyLeftEye, happyRightEye);
        Group eyeSets = new Group(triangleEyes, eyes, happyEyes);
        triangleEyes.setOpacity(0.0);
        happyEyes.setOpacity(0.0);
        Group iceCream = new Group(straw, arms, cherry, upperCream, lowerCream, eyeSets, cone);
        root.add(iceCream, 0, 2);
        cone.setFill(Color.rgb(205, 162, 111));
        cone.setTranslateY(-40.0);
        lowerCream.setTranslateY(-lowerCream.getRadius());
        upperCream.setTranslateY(-upperCream.getRadius() * 2.0);
        cherry.setTranslateY(-80.0);
        straw.setTranslateX(10.0);
        straw.setTranslateY(-77.5);
        straw.setRotate(-45.0);
        iceCream.setTranslateX(-20.0);
        iceCream.setTranslateY(20.0);
        rightArm.setTranslateY(-42.0);
        leftArm.setTranslateX(-leftArm.getWidth());
        leftArm.setTranslateY(-35.0);
        leftArm.setRotate(-45.0);
        leftEye.setTranslateX(-cherry.getRadius());
        rightEye.setTranslateX(cherry.getRadius());
        eyeSets.setTranslateY(-72.5);
        DropShadow shadow = new DropShadow(10.0, Color.BLACK);
        shadow.setOffsetX(5.0);
        shadow.setOffsetY(20.0);
        shadow.setHeight(20.0);
        iceCream.setEffect(shadow);
        RotateTransition wave = new RotateTransition(Duration.seconds(1.0), rightArm);
        wave.setCycleCount(4);
        wave.setByAngle(-45.0);
        wave.setAutoReverse(true);
        TranslateTransition armUp = new TranslateTransition(Duration.seconds(1.0), rightArm);
        armUp.setCycleCount(4);
        armUp.setByY(-7.0);
        armUp.setAutoReverse(true);
        FadeTransition showSpeech = new FadeTransition(Duration.seconds(1.0), speech);
        showSpeech.setCycleCount(1);
        showSpeech.setByValue(1.0);
        RotateTransition armDown = new RotateTransition(Duration.seconds(1.0), rightArm);
        armDown.setDelay(Duration.seconds(4.0));
        armDown.setCycleCount(1);
        armDown.setByAngle(45.0);
        TranslateTransition armAdjust = new TranslateTransition(Duration.seconds(1.0), rightArm);
        armAdjust.setDelay(Duration.seconds(4.0));
        armAdjust.setCycleCount(1);
        armAdjust.setByY(7.0);
        FadeTransition inputFieldShow = new FadeTransition(Duration.seconds(1.0), input);
        inputFieldShow.setCycleCount(1);
        inputFieldShow.setDelay(Duration.seconds(4.0));
        inputFieldShow.setByValue(1.0);
        FadeTransition solveBtnShow = new FadeTransition(Duration.seconds(1.0), solveBtn);
        solveBtnShow.setCycleCount(1);
        solveBtnShow.setDelay(Duration.seconds(4.0));
        solveBtnShow.setByValue(1.0);
        TranslateTransition floater = new TranslateTransition(Duration.seconds(2.0), iceCream);
        floater.setDelay(Duration.seconds(5.0));
        floater.setCycleCount(Integer.MAX_VALUE);
        floater.setByY(-20.0);
        floater.setAutoReverse(true);
        floater.play();
        TranslateTransition fieldLook = new TranslateTransition(Duration.seconds(1.0), eyeSets);
        fieldLook.setDelay(Duration.seconds(4.0));
        fieldLook.setCycleCount(1);
        fieldLook.setByX(leftEye.getRadius());
        solveBtn.setOnAction(e -> {
            result.setOpacity(0.0);
            TranslateTransition resultLook = new TranslateTransition(Duration.seconds(5.0), eyeSets);
            resultLook.setCycleCount(2);
            resultLook.setByY(leftEye.getRadius());
            resultLook.setAutoReverse(true);
            resultLook.play();
            FadeTransition resLabelShow = new FadeTransition(Duration.seconds(1.0), resultLabel);
            resLabelShow.setCycleCount(1);
            resLabelShow.setByValue(1.0);
            resLabelShow.play();
            FadeTransition loadingShow = new FadeTransition(Duration.seconds(1.0), loading);
            loadingShow.setByValue(1.0);
            loadingShow.setCycleCount(1);
            loadingShow.setDelay(Duration.millis(500.0));
            loadingShow.play();
            int i2 = 0;
            while (i2 < 3) {
                FillTransition loadingCycle = new FillTransition(Duration.seconds(1.0), loadingArr[i2], Color.BLACK, Color.WHITE);
                loadingCycle.setCycleCount(3);
                loadingCycle.setDelay(Duration.millis(500 + i2 * 500));
                loadingCycle.setAutoReverse(true);
                loadingCycle.play();
                TranslateTransition loadingHover = new TranslateTransition(Duration.seconds(1.0), loadingArr[i2]);
                loadingHover.setCycleCount(3);
                loadingHover.setDelay(Duration.millis(500 + i2 * 500));
                loadingHover.setAutoReverse(true);
                loadingHover.setByY(-5.0);
                loadingHover.play();
                ++i2;
            }
            String algebraString = input.getText();
            Equation eq = new Equation(algebraString);
            FadeTransition loadingDone = new FadeTransition(Duration.seconds(1.0), loading);
            loadingDone.setCycleCount(1);
            loadingDone.setByValue(-1.0);
            loadingDone.setDelay(Duration.seconds(5.0));
            loadingDone.play();
            FadeTransition resShow = new FadeTransition(Duration.seconds(1.0), result);
            resShow.setCycleCount(1);
            resShow.setByValue(1.0);
            resShow.setDelay(Duration.seconds(5.0));
            resShow.play();
            FadeTransition fadeEyes = new FadeTransition(Duration.millis(500.0), eyes);
            fadeEyes.setDelay(Duration.seconds(4.0));
            fadeEyes.setByValue(-1.0);
            fadeEyes.setCycleCount(1);
            fadeEyes.play();
            if (eq.validateBool() || !eq.getEquation().contains("=")) {
                FadeTransition happy = new FadeTransition(Duration.millis(500.0), happyEyes);
                happy.setDelay(Duration.seconds(4.0));
                happy.setByValue(1.0);
                happy.setCycleCount(1);
                happy.play();
                TranslateTransition raiseEyes = new TranslateTransition(Duration.seconds(2.0), happyEyes);
                raiseEyes.setByY(-leftEye.getRadius());
                raiseEyes.setDelay(Duration.seconds(4.0));
                raiseEyes.setCycleCount(2);
                raiseEyes.setAutoReverse(true);
                raiseEyes.play();
                RotateTransition raiseRightArm = new RotateTransition(Duration.seconds(2.0), rightArm);
                raiseRightArm.setDelay(Duration.seconds(4.0));
                raiseRightArm.setByAngle(-90.0);
                raiseRightArm.setCycleCount(2);
                raiseRightArm.setAutoReverse(true);
                raiseRightArm.play();
                RotateTransition raiseLeftArm = new RotateTransition(Duration.seconds(2.0), leftArm);
                raiseLeftArm.setDelay(Duration.seconds(4.0));
                raiseLeftArm.setByAngle(90.0);
                raiseLeftArm.setCycleCount(2);
                raiseLeftArm.setAutoReverse(true);
                raiseLeftArm.play();
                TranslateTransition armsAdjustment = new TranslateTransition(Duration.seconds(2.0), arms);
                armsAdjustment.setCycleCount(2);
                armsAdjustment.setDelay(Duration.seconds(4.0));
                armsAdjustment.setByY(-7.0);
                armsAdjustment.setAutoReverse(true);
                armsAdjustment.play();
                if (!eq.getEquation().contains("=")) {
                    Expression ex = new Expression(algebraString);
                    result.setText(ex.solve());
                } else {
                    result.setText(eq.solve());
                }
                FadeTransition fadeHappyEyes = new FadeTransition(Duration.millis(500.0), happyEyes);
                fadeHappyEyes.setDelay(Duration.seconds(8.0));
                fadeHappyEyes.setByValue(-1.0);
                fadeHappyEyes.setCycleCount(1);
                fadeHappyEyes.play();
            } else {
                FadeTransition showSadEyes = new FadeTransition(Duration.millis(500.0), triangleEyes);
                showSadEyes.setDelay(Duration.seconds(4.0));
                showSadEyes.setByValue(1.0);
                showSadEyes.setCycleCount(1);
                showSadEyes.play();
                TranslateTransition shake = new TranslateTransition(Duration.seconds(2.0), triangleEyes);
                shake.setDelay(Duration.seconds(4.0));
                shake.setCycleCount(4);
                shake.setByX(-cherry.getRadius());
                shake.setAutoReverse(true);
                shake.play();
                result.setText(eq.validate());
                FadeTransition hideSadEyes = new FadeTransition(Duration.millis(500.0), triangleEyes);
                hideSadEyes.setDelay(Duration.seconds(8.0));
                hideSadEyes.setByValue(-1.0);
                hideSadEyes.setCycleCount(1);
                hideSadEyes.play();
            }
            FadeTransition showEyes = new FadeTransition(Duration.millis(500.0), eyes);
            showEyes.setDelay(Duration.seconds(8.0));
            showEyes.setByValue(1.0);
            showEyes.setCycleCount(1);
            showEyes.play();
        });
        Scene main = new Scene(menu, 575.0, 575.0);
        Scene body = new Scene(root, 575.0, 575.0);
        Scene configurations = new Scene(settings, 575.0, 575.0);
        darkSelect.setOnAction(e -> {
            if (darkSelect.isSelected()) {
                main.setFill(Color.BLACK);
                body.setFill(Color.BLACK);
                configurations.setFill(Color.BLACK);
            } else {
                main.setFill(Color.WHITE);
                body.setFill(Color.WHITE);
                configurations.setFill(Color.WHITE);
            }
        });
        fullSelect.setOnAction(e -> {
            if (fullSelect.isSelected()) {
                mainStage.setFullScreen(true);
            } else {
                mainStage.setFullScreen(false);
            }
        });
        playBtn.setOnAction(e -> {
            mainStage.setScene(body);
            wave.play();
            armUp.play();
            showSpeech.play();
            armDown.play();
            armAdjust.play();
            inputFieldShow.play();
            solveBtnShow.play();
            fieldLook.play();
        });
        settingsBtn.setOnAction(e -> mainStage.setScene(configurations));
        rootBack.setOnAction(e -> {
            mainStage.setScene(main);
            input.setOpacity(0.0);
            solveBtn.setOpacity(0.0);
            resultLabel.setOpacity(0.0);
            result.setOpacity(0.0);
            rightArm.setTranslateY(-42.0);
            rightArm.setRotate(0.0);
            eyeSets.setTranslateX(0.0);
        });
        settingsBack.setOnAction(e -> mainStage.setScene(main));
        exitBtn.setOnAction(e -> Platform.exit());
        mainStage.setScene(main);
        mainStage.show();
    }

    public static void main(String[] args) throws Exception {
        Application.launch(args);
    }
}

